/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz;

import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.rest.RestStatus;

public interface SyncAuthorizationFilter {
    public Result apply(PrivilegesEvaluationContext var1, ActionListener<?> var2);

    public static class Result {
        public static final Result OK = new Result(Status.OK);
        public static final Result DENIED = new Result(Status.DENIED);
        public static final Result INTERCEPTED = new Result(Status.INTERCEPTED);
        private final Status status;
        private final String reason;
        private final Exception exception;

        Result(Status status) {
            this(status, null, null);
        }

        Result(Status status, String message, Exception exception) {
            this.status = status;
            this.reason = message;
            this.exception = exception;
        }

        public Result reason(String message) {
            return new Result(this.status, message, this.exception);
        }

        public Result cause(Exception exception) {
            return new Result(this.status, this.reason, exception);
        }

        public Exception toSecurityException(PrivilegesEvaluationContext context) {
            ElasticsearchSecurityException result = new ElasticsearchSecurityException("Insufficient permissions", RestStatus.FORBIDDEN, (Throwable)(context.isDebugEnabled() ? this.exception : null), new Object[0]);
            if (context.isDebugEnabled()) {
                if (this.reason != null) {
                    result.addMetadata("es.reason_detail", new String[]{this.reason});
                }
                result.addMetadata("es.user", new String[]{String.valueOf(context.getUser())});
                if (context.getMappedRoles() != null) {
                    result.addMetadata("es.effective_roles", context.getMappedRoles().stream().collect(Collectors.toList()));
                }
                result.addMetadata("es.user_attributes", context.getUser().getStructuredAttributes().keySet().stream().collect(Collectors.toList()));
            }
            return result;
        }

        public Status getStatus() {
            return this.status;
        }

        public static enum Status {
            OK,
            DENIED,
            INTERCEPTED;

        }
    }
}

